//
//  GSElement.h
//  GlyphsCore
//
//  Created by Georg Seifert on 10.04.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSBase.h>
#import <GlyphsCore/GSShape.h>
NS_ASSUME_NONNULL_BEGIN

extern CGFloat const MinPrecisionThreshold;
extern CGFloat const MinMeaningfulGrid;

@class GSLayer;

/** GSElement: The base class for Layer elements.

 The base class for Layer elements.
 */

@interface GSElement : GSShape {
  @public
	GSElementOrientation _orientation;
}

#ifndef GLYPHS_VIEWER
- (void)setPropertyListValue:(NSDictionary *)dict format:(GSFormatVersion)format;
#endif

@property (nonatomic) GSElementOrientation orientation;
#ifndef GLYPHS_VIEWER
/**
 Inits with a dict.

 @param dict The property list representation
 @param formatVersion The file format version
 @return a element object
 */
- (instancetype)initWithDict:(NSDictionary *)dict format:(GSFormatVersion)formatVersion;

- (NSString *)elementString;
#endif

- (NSPoint)positionForLayerWidth:(CGFloat)width;
#ifndef GLYPHS_VIEWER
- (void)setPosition:(NSPoint)aPoint forLayerWidth:(CGFloat)width;

- (NSRect)getHandleRect:(NSPoint)pt scale:(CGFloat)scale;

- (BOOL)hitTest:(NSPoint)aPoint tolerance:(CGFloat)tolerance;

- (void)transform:(NSAffineTransform *)transform;

/** rounds the position of the element to grid
 @param grid the grid to round to.
 */
- (void)roundToGrid:(CGFloat)grid;

- (void)roundToGridFast:(CGFloat)grid;
#endif

@end
NS_ASSUME_NONNULL_END
